"use client";

import React from 'react';
import { BarChart3, Settings, Bell, CheckSquare, ShoppingCart, CreditCard } from 'lucide-react';
import { useTranslation } from 'react-i18next';
import { useAuth } from '../hooks/use-auth';

interface MobileNavigationProps {
  activeTab: string;
  setActiveTab: (tab: string) => void;
  tabs: Array<{ id: string; label: string }>;
}

export function MobileNavigation({ activeTab, setActiveTab, tabs }: MobileNavigationProps) {
  const { t } = useTranslation();
  const { user, orderTab } = useAuth();

  // Фильтруем табы по orderTab
  const filteredTabs = tabs.filter(tab => tab.id !== 'order' || orderTab !== false);

  const tabIcons: Record<string, React.ReactNode> = {
    dashboard: <BarChart3 className="h-5 w-5" />,
    'system-settings': <Settings className="h-5 w-5" />,
    notifications: <Bell className="h-5 w-5" />,
    order: <ShoppingCart className="h-5 w-5" />,
  };

  const getTabIcon = (tabId: string) => tabIcons[tabId] || <BarChart3 className="h-5 w-5" />;

  const getTabLabel = (tab: { id: string; label: string }) => t(tab.label, tab.label);

  return (
    <div className="fixed bottom-0 left-0 right-0 z-50 bg-background border-t lg:hidden">
      <div className="flex justify-around items-center h-14 sm:h-16 px-2">
        {filteredTabs.map((tab) => (
          <button
            key={tab.id}
            onClick={() => setActiveTab(tab.id)}
            className={`flex flex-col items-center justify-center flex-1 h-full transition-colors px-1 ${
              activeTab === tab.id
                ? 'text-white bg-[#1B526A]'
                : 'text-muted-foreground hover:text-primary'
            }`}
          >
            <div className="flex items-center justify-center h-5 w-5 sm:h-6 sm:w-6">
              {React.cloneElement(getTabIcon(tab.id) as React.ReactElement, { color: activeTab === tab.id ? 'white' : undefined })}
            </div>
            <span className="text-xs sm:text-sm mt-1 font-medium text-center">
              {getTabLabel(tab)}
            </span>
          </button>
        ))}
      </div>
    </div>
  );
} 