import { NextResponse } from 'next/server';
import { postgresClient } from '../../../../lib/postgresql-client';

export async function GET() {
  try {
    const result = await postgresClient.query('SELECT role_id, role_name, permissions FROM roles ORDER BY role_id ASC');
    return NextResponse.json({ roles: result.rows });
  } catch (error) {
    console.error('Failed to fetch roles:', error);
    return NextResponse.json({ error: 'Failed to fetch roles' }, { status: 500 });
  }
} 