import React, { useEffect, useState } from 'react';
import { Card, CardHeader, CardTitle, CardContent } from '../components/ui/card';
import { useTranslation } from 'react-i18next';

const SystemStatsCard: React.FC = () => {
  const { t } = useTranslation();
  const [stats, setStats] = useState<any>(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState<string | null>(null);

  useEffect(() => {
    setLoading(true);
    fetch('/api/postgres/statistics')
      .then(res => res.json())
      .then(data => {
        setStats(data);
        setLoading(false);
      })
      .catch(err => {
        setError(err.message || 'Ошибка загрузки статистики');
        setLoading(false);
      });
  }, []);

  if (loading) return <div>{t('common.loading', 'Загрузка...')}</div>;
  if (error) return <div style={{ color: 'red' }}>{error}</div>;

  // Единицы измерения по языку
  const waterUnit = t('gaugeChart.waterUsage', 'м³');
  const electricUnit = t('gaugeChart.electricityUsage', 'кВт⋅ч');

  return (
    <div className="w-full max-w-2xl mx-auto grid grid-cols-1 md:grid-cols-2 gap-4">
      <Card className="shadow-lg flex flex-col items-center justify-center">
        <CardHeader className="w-full flex flex-col items-center justify-center">
          <CardTitle className="text-center w-full">{t('managerPanel.usersCount', 'Количество пользователей')}</CardTitle>
        </CardHeader>
        <CardContent className="flex flex-col items-center justify-center w-full">
          <div className="text-2xl font-bold text-center w-full">{stats?.usersCount ?? '—'}</div>
        </CardContent>
      </Card>
      <Card className="shadow-lg flex flex-col items-center justify-center">
        <CardHeader className="w-full flex flex-col items-center justify-center">
          <CardTitle className="text-center w-full">{t('managerPanel.devicesCount', 'Количество подключённых устройств')}</CardTitle>
        </CardHeader>
        <CardContent className="flex flex-col items-center justify-center w-full">
          <div className="text-2xl font-bold text-center w-full">{stats?.devicesCount ?? '—'}</div>
        </CardContent>
      </Card>
      <Card className="shadow-lg flex flex-col items-center justify-center">
        <CardHeader className="w-full flex flex-col items-center justify-center">
          <CardTitle className="text-center w-full">{t('managerPanel.waterUsage', 'Сумма использования воды')}</CardTitle>
        </CardHeader>
        <CardContent className="flex flex-col items-center justify-center w-full">
          <div className="text-2xl font-bold text-center w-full">{stats?.waterUsage?.toLocaleString(undefined, { maximumFractionDigits: 2 }) ?? '—'}</div>
          <div className="text-base font-normal text-center w-full mt-1">m³</div>
        </CardContent>
      </Card>
      <Card className="shadow-lg flex flex-col items-center justify-center">
        <CardHeader className="w-full flex flex-col items-center justify-center">
          <CardTitle className="text-center w-full">{t('managerPanel.electricUsage', 'Сумма использования электричества')}</CardTitle>
        </CardHeader>
        <CardContent className="flex flex-col items-center justify-center w-full">
          <div className="text-2xl font-bold text-center w-full">{stats?.electricUsage?.toLocaleString(undefined, { maximumFractionDigits: 2 }) ?? '—'}</div>
          <div className="text-base font-normal text-center w-full mt-1">kWh</div>
        </CardContent>
      </Card>
    </div>
  );
};

export default SystemStatsCard; 